@extends('app')
@section('content')
<style>

            /*.product {*/
            /*    width: calc(25% - -146px) !important;*/
            /*}*/
          
          .sidebar-main{
            width: 340px;
            background: rgba(255, 255, 255, 0);
            height: 100%;
            max-height: auto;
            padding: 20px;
          }
          
          .sidebar {
            min-height: 600px;
            border: 0px solid black;
            padding: 10px;
            font-family: 'Poppins', sans-serif;
            height: 100%;
        }
        .sidebar_dismiss{
            position: absolute;
            top: 20px;
            right: 20px;
          }
        @media (max-width: 1200px) {
            .sidebar-main{
              width: 300px;
              background: white;
              position: fixed;
              left: -300px;
              top: 0;
              visibility: hidden;
              opacity: 0;
              height: 100%;
              z-index: 999;
              max-height: 100vh;
              overflow-y: auto;
              padding: 20px;
            }
            .sidebar-main.active{
              visibility: visible;
              opacity: 1;
              left: 0;
            }
          }
          ul.categories{
            position: relative;
            width: 100%;
            padding-top: 10px;
            padding-left: 10px;
        }
        ul li{
          list-style: none;
        }
        .categories .category .checkbox{
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            margin-bottom: 0;
            padding: 5px;
            display: flex;
            align-items: center;
            margin-top: 0;
        }
        .categories .category > .checkbox{
            color: #00aeef;
        }
        .categories .category .checkbox input:focus{
            border: none;
            outline: none;
        }
        .categories .category .checkbox .shop_checkbox{
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-color: rgba(65, 66, 71, 0.08);
            border: none;
            height: 1.5rem;
            margin: 0;
            margin-right: 0.5rem;
            position: relative;
            width: 1.5rem;
            margin-top: -1px;
        }
        .categories .category .checkbox .shop_checkbox::after{
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-color: rgba(65, 66, 71, 0.08);
            border: none;
            height: 1rem;
            margin: 0;
            margin-right: 0.5rem;
            position: relative;
            width: 1rem;
            margin-top: -1px;
        }
        .categories .category .sub_categories{
            padding-left: 20px;
        }
        .categories .category .sub_cateogries > .checkbox{
            font-weight: 700;
        }
        .categories .category .checkbox .badge{
            position: absolute;
            right: 10px;
            background: rgba(65, 66, 71, 0.08);
            color: black;
        }
        .categories .category .checkbox.active .shop_checkbox{
            background-color: #ffc107;
            position: relative;
        }
        .categories .category .checkbox.active .shop_checkbox::after{
            background-color: #fff;
            border-radius: 4px;
            content: '';
            height: 4px;
            left: 50%;
            position: absolute;
            top: 50%;
            transform: translateX(-2px) translateY(-1px);
            width: 4px;
        }
        @media (min-width: 1200px){
          .shop_products{
            width: calc(100% - 350px);
            align-items: flex-start;
          }
          .shop_products .product{
            width: calc(25% - 10px);
          }
        }
        .price-input {
          width: 100%;
          display: flex;
          margin: 10px 0 10px;
        }
        .price-input .field {
          display: flex;
          width: 100%;
          height: 45px;
          align-items: center;
        }
        .price-input .field .price_symbol {
          font-size: 18px;
          margin: 0;
      }
        .field input {
          width: 100%;
          height: 25px;
          outline: none;
          font-size: 16px;
          margin-left: 5px;
          border-radius: 5px;
          text-align: center;
          border: 1px solid #dfdfdf;
          -moz-appearance: textfield;
        }
        .price-input .field span {
            font-weight: 500;
            font-size: 14px;
        }
        input[type="number"]::-webkit-outer-spin-button,
        input[type="number"]::-webkit-inner-spin-button {
          -webkit-appearance: none;
        }
        .price-input .separator {
          width: 50px;
          display: flex;
          font-size: 19px;
          align-items: center;
          justify-content: center;
        }
        .slider {
          height: 5px;
          position: relative;
          background: #ddd;
          border-radius: 5px;
          margin-top: 20px;
        }
        .slider .progress {
          height: 100%;
          left: 4%;
          right: 25%;
          position: absolute;
          border-radius: 5px;
          background: #ff5f02;
        }
        .range-input {
          position: relative;
        }
        .range-input input {
          position: absolute;
          width: 100%;
          height: 5px;
          top: -5px;
          background: none;
          pointer-events: none;
          -webkit-appearance: none;
          -moz-appearance: none;
        }
        input[type="range"]::-webkit-slider-thumb {
          height: 17px;
          width: 17px;
          border-radius: 50%;
          background: #ff5f02;
          pointer-events: auto;
          -webkit-appearance: none;
          box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
        }
        input[type="range"]::-moz-range-thumb {
          height: 17px;
          width: 17px;
          border: none;
          border-radius: 50%;
          background: #ff5f02;
          pointer-events: auto;
          -moz-appearance: none;
          box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
        }
        </style>

<div class="container-xl">
    <div class="d-flex justify-content-end align-items-center my-3">
        
    <button class="btn btn-warning filter_btn_shop d-xl-none"><i class="fa fa-filter"></i> Filter By</button>
    </div>
    <div class="row">
        <div class="sidebar-main">
            <div class="">
                <div class="sidebar">
                    <button class="sidebar_dismiss btn d-lg-none"><i class="fa fa-times"></i></button>
                    <div class="sidebar-categories area">
                        <a href="#sidebar-categories" class="sidebar-title pop semi ls-2 text-dark" data-bs-toggle="collapse">Categories</a>
                        <hr>
                        <div id="sidebar-categories" class="collapse show">
                          <ul class="categories">
                              
                            @foreach($categories as $cat)
                            <li class="category">
                                <div class="checkbox {{$cat->id==request('cat_id') ?'active':''}}">
                                    <input type="checkbox" class="shop_checkbox {{$cat->id==request('cat_id') ?'checked':''}} category_id" value="{{$cat->id}}">
                                    <div> {{$cat->name}} </div>
                                    <span class="badge">{{$cat->products->count()}} </span>
                                </div>
                                @if($cat->sub_categories)
                                <ul class="sub_categories">
                                    @foreach($cat->sub_categories as $sub_cat)
                                    <li class="sub_category">
                                        <div class="checkbox">
                                            <input type="checkbox" class="shop_checkbox category_id" value="{{ $sub_cat->id}}" data-name="Denim Pant">
                                            <div> {{ $sub_cat->name}}  </div>
                                            <span class="badge"> {{$sub_cat->products->count()}} </span>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                                @endif
                            </li>
                            @endforeach
                            
                          </ul>
                        </div>
                    </div>
                    <div class="sidebar-sort area">
                        <a href="#sidebar-sort" class="sidebar-title pop semi ls-2 text-dark" data-bs-toggle="collapse">Sort By</a>
                        <hr>
                        <div id="sidebar-sort" class="collapse show">
                            <select name="ordering" id="ordering" class="form-control ordering">
                              <option value="asc">Product title (A-z)</option>
                                <option value="desc">Product title (Z-a)</option>
                                <option value="price_low">Price: Lowest to Highest</option>
                                <option value="price_high">Price: Highest to Lowest</option>
                            </select>
                        </div>
                    </div>
                    <div class="area mt-4">
                        <a href="#sidebar-price" class="sidebar-title pop semi ls-2 text-dark" data-bs-toggle="collapse">Filter By Price</a>
                        <hr>
                        <div class="section collapse show" id="sidebar-price">
                          <div class="section_body">
                            <div class="slider">
                                <div class="progress"></div>
                            </div>
                            <div class="range-input">
                                <input type="range" class="range-min" min="0" max="10000" value="0" step="100">
                                <input type="range" class="range-max" min="0" max="10000" value="10000" step="100">
                            </div>
                            <div class="price-input d-flex justify-content-between">
                                <div class="field">
                                  <span>Min</span>
                                  <input type="number" class="input-min form-control" value="0"> <h4 class="price_symbol">৳</h4>
                                </div>
                                <div class="separator">-</div>
                                <div class="field">
                                  <span>Max</span>
                                  <input type="number" class="input-max form-control" value="10000"> <h4 class="price_symbol">৳</h4>
                                </div>
                            </div>
                          </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
              
    <div class="products shop_products mt-3">
        
    </div>
    </div>
</div>

@endsection

@push('js')
<script>
   
   $(document).ready(function(){
        getProduct();
        $('.categories .category div.checkbox').click(function(){
            $(this).toggleClass('active');
            var checkbox = $(this).find('.shop_checkbox');
            checkbox.toggleClass('checked');
            checkbox.prop('checked', !checkbox.prop('checked'));
            getProduct();
          
        });
    })
    $(document).ready(function () {
      const rangeInput = $(".range-input input");
      const priceInput = $(".price-input input");
      const range = $(".slider .progress");
      let priceGap = 1000;
  
      var timer;
      priceInput.on("input", function (e) {
        let minPrice = parseInt(priceInput.eq(0).val());
        let maxPrice = parseInt(priceInput.eq(1).val());
    
        if (maxPrice - minPrice >= priceGap && maxPrice <= rangeInput.eq(1).attr("max")) {
          if ($(this).hasClass("input-min")) {
            rangeInput.eq(0).val(minPrice);
            range.css("left", (minPrice / rangeInput.eq(0).attr("max")) * 100 + "%");
          } else {
            rangeInput.eq(1).val(maxPrice);
            range.css("right", (100 - (maxPrice / rangeInput.eq(1).attr("max")) * 100) + "%");
          }
        }
    });
    
    rangeInput.on("input", function (e) {
        let minVal = parseInt(rangeInput.eq(0).val());
        let maxVal = parseInt(rangeInput.eq(1).val());
    
        if (maxVal - minVal < priceGap) {
          if ($(this).hasClass("range-min")) {
            rangeInput.eq(0).val(maxVal - priceGap);
          } else {
            rangeInput.eq(1).val(minVal + priceGap);
          }
        } else {
          priceInput.eq(0).val(minVal);
          priceInput.eq(1).val(maxVal);
          range.css("left", (minVal / rangeInput.eq(0).attr("max")) * 100 + "%");
          range.css("right", (100 - (maxVal / rangeInput.eq(1).attr("max")) * 100) + "%");
        }
        
        
        clearTimeout(timer);
            var ms = 700; // milliseconds
            timer = setTimeout(function() {
              getProduct();
            }, ms);
   
   
    });
    });
    
    $('select.ordering').change(function(){
        getProduct();
        
    })

    function getProduct(page=null){
        let order=$(document).find('select.ordering option:selected').val();
        let color_id=$(document).find('select.color option:selected').val();
        let min_price=$(document).find('input.input-min').val();
        let max_price=$(document).find('input.input-max').val();
        let q=$(document).find('input#search_q').val();
        
        var cat_id = []
        let cat_text='<div class="tag_item">Cats:</div>';
        
        $("input.category_id.checked").each(function (){
            
            let text=$(this).data('name');
            cat_text+='<div class="tag_item">'+text+'</div>';
            cat_id.push(parseInt($(this).val()));
        });
        
        $('.tags_selected').html(cat_text);
        
        
        var new_cat_id = []
        $("input.new_category_id.checked").each(function (){
            
            new_cat_id.push(parseInt($(this).val()));
        });
        
  
        
    
        $.ajax({
            type: 'GET', //THIS NEEDS TO BE GET
            url: '{{ route("shop")}}?page='+page,
            data:{order,min_price,max_price,cat_id,new_cat_id,color_id,q},
            success: function (data) {
                
                 $("div.shop_products").html(data.html);
            },
            error: function() { 
                 
            }
        });
    }
    
    $(document).on('click', ".pagination a", function(e) {
      e.preventDefault();
      $('li').removeClass('active');
      $(this).parent('li').addClass('active');
      var page = $(this).attr('href').split('page=')[1];
      getProduct(page);
    });
</script>
@endpush