@extends('app')
@push('css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0.17/dist/fancybox/fancybox.css"/>
<link rel="stylesheet" href="{{ asset('assets/css/easyzoom.css')}}">
<link rel="stylesheet" href="{{ asset('assets/css/single.css')}}">

@php
use App\Models\EcommerceSetting;
$ecom_setting = EcommerceSetting::first();
@endphp


<style>
    .quantity_box{
        display: inline-flex;
        vertical-align: top;
        white-space: nowrap;
        font-size: 0;
        margin-bottom: 10px;
        width: 100%;
    }
    div.quantity_box button[type="button"] {
        padding: 0 5px;
        min-width: 25px;
        min-height: unset;
        height: 42px;
        border: 2px solid rgb(211, 211, 211);
        background: white;
        box-shadow: none;
        color: black;
        border-radius: 0;
    }
    div.quantity_box button[type="button"]:hover {
        color: #fff;
        background-color: orange;
        border-color: orange;
    }
    div.quantity_box input[type="text"] {
        width: 40px;
        color: black;
        border-radius: 0;
        border: 2px solid rgb(211, 211, 211);
        border-right: none;
        border-left: none;
    }
    div.quantity_box button[type="button"].minus {
        border-radius: 10px 0 0 10px;
    }
    div.quantity_box button[type="button"].plus {
        border-radius: 0 10px 10px 0;
    }
    
   .burmanRadio {
        margin-bottom: 10px;
      }
      .burmanRadio__input {
        display: none;
      }
      .burmanRadio__input:checked ~ .burmanRadio__label::after {
        opacity: 1;
        transform: scale(1);
      }
      .burmanRadio__label {
        cursor: pointer;
        line-height: 30px;
        position: relative;
        margin-left: 35px;
      }
      .burmanRadio__label::before, .burmanRadio__label::after {
        border-radius: 50%;
        position: absolute;
        top: 5px;
        left: -30px;
        transition: all 0.3s ease-out;
        z-index: 2;
      }
      .burmanRadio__label::before {
        content: "";
        border: 1.5px solid #9d9d9d;
        width: 20px;
        height: 20px;
      }
      .burmanRadio__label::after {
        font-family: "Font Awesome 5 Free"; font-weight: 900; content: "\f00c";
        background: #ffc107;
        border: 1.5px solid #ffc107;
        color: #FFF;
        display: flex;
        justify-content: center;
        align-items: center;
        opacity: 0;
        width: 20px;
        height: 20px;
        transform: scale(0);
      }
      .burmanRadio__label:hover::before {
        border-color: #7BC4CA;
      }
     .main-wrapper{
         background: #f8f9fa;
     }
           
    .carousel-inner {
        position: relative;
        width: 100%;
        overflow: hidden;
        box-shadow: 0px 0px 7px 0px gray;
        border-radius: 10px;
    }     
    .nav_images{
        margin-top: 10px;
    }
    .nav_images [data-bs-target] {
        height: 70px;
        width: 70px;
        box-shadow: 0px 0px 3px 0px gray;
        padding: 5px;
    }
    
    .nav_images .active {
        height: 70px;
        width: 70px;
    }
    .carousel-indicators [data-bs-target]{
        border: 0;
    }
    
   @media screen and (min-width: 320px) and (max-width: 767px) {
       .btn_submit {
           display: inline !important;
       }
   }
   
   .call_now button {
       width: 100%;
   }
   
   .call_now {
       margin-top: 10px;
   }
    
    
</style>
            
@endpush
@section('content')

@php
    $pdata=getProductInfo($single_product);
    
@endphp

<div class="container-xl mt-5">
    <div class="row justify-content-between">
        <div class="col-lg-5 col-md-6 col-sm-8 col-12">
            <div id="product" class="carousel slide" data-bs-ride="false" >
                <div class="carousel-inner" role="listbox">
                    <div class="carousel-item active shadow-lg">
                        <div class="easyzoom easyzoom--overlay w-100">
                            <a href="{{ getImage('images/product/large', $single_product->main_image)}}" data-fancybox="gallery" class="fancybox">
                                <img
                                src="{{ getImage('images/product/large', $single_product->main_image)}}"
                                class="w-100"
                                alt="First slide"
                            />
                            </a>
                        </div>
                        
                    </div>
                    
                    @foreach($single_product->images as $key=>$im)
                    <div class="carousel-item {{$im->color}} shadow-lg">
                        <div class="easyzoom easyzoom--overlay w-100">
                            <a href="{{ getImage('images/product/large', $im->image)}}"  data-fancybox="gallery" class="fancybox">
                                <img
                                src="{{ getImage('images/product/large', $im->image)}}"
                                class="w-100"
                                alt="First slide"
                            />
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#product" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#product" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
                
            </div>
            <div class="carousel-indicators nav_images position-relative" id="nav_images">
                
                
                <img src="{{ getImage('images/product/large', $single_product->main_image)}}" alt="" width="100" data-bs-target="#product" data-bs-slide-to="0" class="active" aria-current="true">
                @foreach($single_product->images as $key=>$im)
                
                <img src="{{ getImage('images/product/large', $im->image)}}" alt="" width="100" data-bs-target="#product" data-bs-slide-to="{{$key+1}}">
                @endforeach
            </div>
            
        </div>
        <div class="col-lg-6 col-md-6 col-sm-8 col-12">
            
            <h2 class="title light">{!! $single_product->name !!} </h2>
            <h4 class="pop bold"> {!! $pdata['price'] !!} Tk</h4>
            
            
            
            <div class="size_chart mt-3 d-none">
                <img src="{{ asset('assets/image/size.png')}}" alt="" class="img-fluid">
            </div>
            
            
            <form method="POST" action="{{ route('carts.store')}}">
            @if($single_product->is_variant)
            @foreach($options as $key=>$option)
            
            @php
                $vs=explode(",",$values[$key]);
                $op=str_replace('"','',$option);
            @endphp
            
            <div class="d-flex">
            <h4 class="pop medium">{{$op}}:</h4>
                
            <div class="sizes d-flex flex-wrap align-items-center gap-4">
                @foreach($vs as $i=>$v)
                @php
                    $value=str_replace('"','',$v);
                @endphp
                <div class="burmanRadio">
                    <input type="radio" class="burmanRadio__input {{$op}}" id="size-{{$value}}" {{$i==0?'checked':''}} name="variant_{{$key+1}}" value="{{ $value }}">
                    <label for="size-{{$value}}" class="burmanRadio__label"> {{ $value }} </label>
                </div>
                @endforeach
            </div>
            </div>
            @endforeach
            @endif 
        
            <div class="align-items-center flex-wrap mt-4 col-lg-8">
                @csrf
                <input type="hidden" name="product_id" value="{{ $single_product->id}}">
        
                <div class="quantity_box">
                    <button type="button" class="minus btn">-</button>
                    <input type="text" class="quantity_value placeholder_black form-control" name="quantity" value="1"  min="1" max="12" >
                    <button type="button" class="plus btn">+</button>
                </div>
                <div class="d-flex btn_submit">
                <button type="submit" class="btn btn-warning mt-lg-0 mt-3 semi text-cap col-lg-6 col-md-6 col-12" style="width: 48%;">অর্ডার করুন</button>
                <button class="btn btn-warning ms-lg-3 mt-lg-0 mt-3 semi text-cap col-lg-6 col-md-6 col-12 add_to_cart" style="width: 48%;">কার্টে রাখুন</button>
                </div>
                <div class="call_now">
                    <a href="tel: {{ $ecom_setting->contact }}" class="btn btn-warning mt-lg-0 mt-3 semi text-cap col-lg-6 col-md-6 col-12 add_to_cart w-100" style="background: #00276C;color: #ffffff;border: none;"><i class="fas fa-phone" style="padding-right: 7px;"></i>{{ $ecom_setting->contact }}</a>
                </div>
            </div>
            </form>
            
            
        </div>
    </div>



    </div>
    <div class="description_tab mt-4">
    <div class="container-xl">
        <!-- Nav tabs -->
    <ul class="nav nav-tabs justify-content-start border-0 gap-3" id="product_des" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active border-0" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">
                Product Details
            </button>
        </li>
        <li class="nav-item d-none" role="presentation">
            <button class="nav-link border-0" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                Profile
            </button>
        </li>
    </ul>

    <!-- Tab panes -->
    <div class="tab-content my-5">
        <div class="tab-pane active" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="wc-tab-inner">
                {!! str_replace('@','"', $single_product->product_details) !!}
                
                
                
            </div>
        </div>
        <div class="tab-pane" id="profile" role="tabpanel" aria-labelledby="profile-tab">
             <div class="row">
                <div class="col-lg-6">
                    <p class="">Only logged in customers who have purchased this product may leave a review.</p>
                </div>
                <div class="col-lg-6">
                    <h5 class="text-cap">REVIEWS</h5>
                    <p>There are no reviews yet.</p>
                </div>
             </div>
        </div>
    </div>
    </div>

    </div>
    <div class="container-xl">
        <h3>Related Products</h3>
        <div class="products mt-3">
            @foreach($products as $product)
            @include('partials.product')
            @endforeach
        </div>
    </div>
    <br><br>

@endsection

@push('js')
<script src="{{ asset('assets/js/easyzoom.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0.17/dist/fancybox/fancybox.umd.js"></script>

<script>
    $(document).on('click','.color', function(){
        
        let color_name=$(document).find('.color:checked').val();
        
        if(color_name){
            if($(document).find('.carousel-item').hasClass(color_name)){
                $(document).find('.carousel-item').removeClass('active');
                $(document).find('.'+color_name).addClass('active');
            }else{
                
            }
        }
        
    });
    
    $(document).on('click', 'button.add_to_cart', function(e) {
        e.preventDefault();
       
        var formData = $(this).closest('form').serialize();
        var url = "{{ route('cartstore')}}";
        
        var method = "POST";
        $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }});
        
        $.ajax({
            url: url,
            method: method,
            data: formData,
            success: function(res) {
                if(res.success) {
                    toastr.success(res.msg);
                    window.location.reload();
                }
            }
        });
    });
    
</script>
@endpush