@extends('app')
@push('css')
<style>
    .error{
        
        color:red;
    }
</style>
@endpush
@section('content')

<div class="container-xl my-5">
    <div class="row g-5">
        
        <div class="col-md-12 col-lg-6 order-md-last order-last">
            <div class="card mb-4">
                <div class="card-header"><h5 class="mb-0">Cart - {{ getTotalCart()}} items</h5></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                          <thead>
                            <tr>
                                <th scope="col">ছবি</th>
                                <th scope="col">পন্যের নাম</th>
                                <th scope="col">সাইজ/কালার</th>
                                <th scope="col">পরিমান</th>
                                <th scope="col">পন্যের দাম</th>
                            </tr>
                          </thead>
                          <tbody>
                                @php
                                    $total=0;
                                @endphp
                        
                                @foreach($cart as $key=>$item)
                                
                                @php
                                $sub_total=$item['price']*$item['quantity'];
                                $total +=$sub_total;
                                @endphp
                            <tr> 
                              <th scope="row">
                                    <div class="d-flex">
                                        <form method="POST" action="{{ route('carts.destroy',[$key])}}">
                                            @csrf
                                            @method('DELETE')
                                            <div class="remove">
                                                <button class="btn remove-item" type="submit">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </div>
                                        </form>
                                       <img src="{{ getImage('images/product/large', $item['image'])}}" alt="" class="rounded border" style="height: 60px;width: 60px;" width="">
                                    </div>
                                </th>
                              <td>{{$item['name']}}</td>
                              <td>
                                 @if($item['variants'])
                                @foreach($item['variants'] as $v)
                                @if($v->id==$item['variant_id'])
                                <p class="mb-1">Size/Color :{{$v->name}}</p>
                                @endif
                                @endforeach
                                @endif
                              </td>
                              <td>
                                    <div class="d-flex mb-4 align-items-start" style="max-width: 300px" data-href="{{ route('carts.edit',[$key])}}">
                                      <button class="btn btn-primary me-2 qtybtn minus">
                                        <i class="fas fa-minus"></i>
                                      </button>
                                      <div class="form-outline">
                                        <input id="form1" min="1" name="quantity" value="{{$item['quantity']}}" style="width: 40px;" type="text" readonly class="form-control quantity" />
                                      </div>
                                      <button class="btn btn-primary ms-2 qtybtn plus">
                                        <i class="fas fa-plus"></i>
                                      </button>
                                    </div>
                                </td>
                                <td>
                                <strong> {{$item['price']}} </strong>
                                  @if($item['discount'])
                                  Discount: <strong> {{$item['discount']}} </strong>
                                  @endif  
                                </td>
                            </tr>
                            @endforeach
                            
                            <tr>
                                <td colspan="4" class="text-end">সাবটোটাল</td>
                                <td>{{$total}} ৳</td>
                            </tr>
                            <tr>
                                <td colspan="4" class="text-end">ডেলিভারি চার্জ</td>
                                <td><p id="shipping_cost">0.00 ৳</p></td>
                            </tr>
                            
                            @if(getTotalDiscount()>0)

                            <tr>
                                <td colspan="4" class="text-end">ডিসকাউন্ট </td>
                                <td><p>{{getTotalDiscount()}} ৳</p></td>
                            </tr>
                            @endif
                            
                            @php
                                $total=$total-getTotalDiscount();
                            @endphp
                                
                            <tr>
                                <td colspan="4" class="text-end">টোটাল</td>
                                <td><p id="total_amount">{{$total}}</p></td>
                            </tr>
                          </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            
            
          </div>
          

        <div class="col-md-6 col-lg-6">
          <h4 class="mb-3">Billing address</h4>
          <form class="needs-validation" action="{{ route('checkouts.store')}}" method="post">
            @csrf
            <div class="row g-3">
                <div class="col-sm-12">
                    <label for="firstName" class="form-label">Your Full Name</label>
                    <input type="text" class="form-control p-2" placeholder="Enter Name " value="{{ old('name')}}" name="name">
                    @if($errors->has('mobile'))
                        <div class="error">{{ $errors->first('name') }}</div>
                    @endif
                 </div>
                 
                <div class="col-sm-12">
                    <label for="firstName" class="form-label">Your Mobile Number</label>
                    <input type="text" class="form-control" placeholder="Enter Mobile .." value="{{ old('mobile')}}" name="mobile">
                    @if($errors->has('mobile'))
                        <div class="error">{{ $errors->first('mobile') }}</div>
                    @endif
                 </div>
                 
 
                <div class="col-12">
                    <label for="address" class="form-label">Your Fulll Address</label>
                    <input type="text" class="form-control p-4" placeholder="Enter Address .." name="address" value="{{ old('address')}}" >
                    @if($errors->has('address'))
                        <div class="error">{{ $errors->first('address') }}</div>
                    @endif
                </div>
                
                <div class="col-12">
                    <label for="shipping_charge" class="form-label">Shipping Charge</label>
                    <select class="form-select shadow-none" id="shipping_charge" name="shipping_charge">
                      <option value="60">Inside Dhaka (60)</option>
                      <option value="120">Outside Dhaka (120)</option>
                    </select>
                </div>
                
                <div class="col-12">
                    <label for="state" class="form-label">Payment Method</label>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" name="paying_method" id="cash_on_delivery" value="cash_on_delivery" checked>
                        <label class="form-check-label" for="cash_on_delivery">
                            Cash On Delivery
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="paying_method" id="bkash" value="bkash" >
                        <label class="form-check-label" for="bkash">
                            Bkash
                        </label>
                    </div>

                </div>
  
            
            <hr class="my-4">
  
            <button class="w-100 btn btn-warning btn-lg" type="submit">Continue to checkout</button>
          </form>
        </div>
      </div>
    </div>
</div>

            
@endsection
@push('js')
<script>
    $(document).ready(function(){
        $('#shipping_charge').change(function(){
            getShippingCost();
            
        });
        getShippingCost();
        
        function getShippingCost(){
            
            let amount=Number('{{$total}}');
            let charge=Number($('#shipping_charge').find('option:selected').val());
            $(document).find('#shipping_cost').text(charge);
            $(document).find('p#total_amount').text(amount+charge);
            console.log(amount+charge);
            
            
        }
        
        $(document).on('click','button.qtybtn', function() {
            var $button = $(this);
    
            var oldValue = $button.parent().find('input.quantity').val();
            if ($button.hasClass('plus')) {
                var newVal = parseFloat(oldValue) + 1;
            } else {
                // Don't allow decrementing below zero
                if (oldValue > 1) {
                    var newVal = parseFloat(oldValue) - 1;
                } else {
                    newVal = 1;
                }
            }
            $button.parent().find('input.quantity').val(newVal);
    
            let url=$button.closest('div').attr('data-href');
    	    if (typeof url !== "undefined") {
    		    $.ajax({
    		        url: url,
    		        method: "GET",
    		        data: {quantity:newVal},
    		        success: function (res) {
    		            if (res.success) {
    		                toastr.success(res.msg);
    		                
                            window.location.reload();
                            
    		            }else{
    		                toastr.error(res.msg);
    		            }
    		           
    		        }
    		    });
    		}
    
        });
        
        
        $(document).on('change','input.quantity', function() {
            var $input = $(this);
    
            var oldValue = $input.val();
            if(1>oldValue){
                return false;
            }
    
            let url=$input.closest('div.align-items-start').attr('data-href');
    	    if (typeof url !== "undefined") {
    		    $.ajax({
    		        url: url,
    		        method: "GET",
    		        data: {quantity:oldValue},
    		        success: function (res) {
    		            if (res.success) {
    		                toastr.success(res.msg);
    		                
                            window.location.reload();
                            
    		            }else{
    		                toastr.error(res.msg);
    		            }
    		           
    		        }
    		    });
    		}
    
        });
        
    
    
    });
</script>
@endpush