@extends('app')
@section('title')
<title>My Orders</title>
@endsection
@push('css')

<style type="text/css">
    .myrecentorder tr td, th {
        padding: 5px !important;
    }
    .userdashboard{
        min-height: 500px;
    }
    @media (max-width: 768px) {
       .userdashboard{
            min-height: 300px;
        } 
    }
</style>

@endpush
@section('content')

<div class="userdashboard">
    <div class="container">
    <div class="row" style="margin:0;">
        <div class="col-lg-3 usersidebardiv">
            @include('customer.includes.sidebar')
        </div>
        <div class="col-lg-9 usermainbody">



            <div class="usercontent">
                <div class="myrecentorder" style="min-height: 300px;">
                    <p style="font-weight: bold;padding-top: 5px;">My Orders</p>
                    <div style="overflow: auto;">
                  

                    <table class="table table-bordered">

                        <tr>
                            <th style="width: 50px;min-width: 50px;">SL</th>
                            <th style="width: 150px;min-width: 150px;">Invoice</th>
                            <th style="width: 170px;min-width: 170px;">Placed On</th>
                            <th style="width: 50px;min-width: 50px;">Items</th>
                            <th style="width: 150px;min-width: 150px;">Total</th>
                            <th style="width: 80px;min-width: 80px;">Status</th>
                        </tr>
                        @foreach($orders as $i=>$order)
                        <tr>
                            <td>{{$orders->currentpage()==1?$i+1:$i+($orders->perpage()*($orders->currentpage() - 1))+1}}</td>
                            <td><a href="#">{{ $order->reference_no }}</a></td>
                            <td>{{ $order->created_at->format('d-m-Y h:i A') }}</td>
                            <td>
                                @foreach($order->products as $p)
                                {{$p->name}} - ({{ $p->variantName}})
                                @endforeach
                            </td>
                            <td>{{ $order->grand_total}}</td>
                            
                            <td style="font-size: 14px;padding: 4px;">
                                @if($order->sale_status==1)
                                <span class="badge badge-success" style="background:#e91e63;">Complete</span>
                                @elseif($order->sale_status==2)
                                <span class="badge badge-success" style="background:#673ab7;">Pending</span>
                                @elseif($order->sale_status==5)
                                <span class="badge badge-success" style="background:#1c84c6;">Packing</span>
                                @elseif($order->sale_status==3)
                                <span class="badge badge-success" style="background:#000;">Draft</span>
                                @elseif($order->sale_status==4)
                                <span class="badge badge-success" style="background:#ff005e;">Return</span>
                                @elseif($order->sale_status==6)
                                <span class="badge badge-success" style="background:#15ab81;">Delivering</span>
                                @elseif($order->sale_status==7)
                                <span class="badge badge-success" style="background:#f44336;">Delivered</span>
                                @elseif($order->sale_status==8)
                                <span class="badge badge-success" style="background:#ff0b0b;">Cancelled</span>
                                @elseif($order->sale_status==9)
                                <span class="badge badge-success" style="background:#ddd607;">On Hold</span>
                                @elseif($order->sale_status==10)
                                <span class="badge badge-success" style="background:#ff00f7;">Exchange</span>
                                @endif
                            </td>
                        </tr>
                       
                        @endforeach
                    </table>


                    {!! $orders->links() !!}
                    </div>
                </div>
            </div>


        </div>
    </div>
    </div>
</div>
@endsection
@push('js')
@endpush