@extends(App\Models\General::first()->theme.'.layouts.app') @section('title')
<title>invoice | {{App\Models\General::first()->title}} | {{App\Models\General::first()->subtitle}}</title>
@endsection @section('SEO')
<meta name="description" content="{!!App\Models\General::latest()->first()->meta_dsc!!}" />
<meta name="keywords" content="{{App\Models\General::latest()->first()->meta_key}}" />
<meta property="og:title" content="{{App\Models\General::latest()->first()->name}}" />
<meta property="og:description" content="{!!App\Models\General::latest()->first()->meta_dsc!!}" />
<meta property="og:image" content="{!!App\Models\General::latest()->first()->meta_dsc!!}" />
<meta property="og:url" content="{{route('index')}}" />

@endsection 

@push('css')


<style type="text/css">
    .invoiceContainer {
        overflow: auto;
    }
    .invoice-inner {
        border: 1px solid #ccc;
        padding: 10px 20px;
        min-width:700px;
    }
    
    .invoice-header {
        padding: 20px 0px 35px;
    }
    
    .invoice-header img{
        width: 100%;
    }
    
    .invoice-header h6{
        margin-top: 15px!important;
    }
    
    .invoice-header h6, p{
        margin: 0;
        line-height: 15px;
        font-size: 12px;
    }
    
    .invoice-inner h2{
        margin: 10px 0px;
        font-size: 41px;
        letter-spacing: 3px;
        color: #00549e;
    }
    
    .ordrinfotable {
        padding: 10px 12px;
        border: 1px solid #ccc;
    }
    
    table.tableOrderinfo.table {
        margin: 0;
        padding: 0;
    }
    
    .tableOrderinfo td{
        padding: 0;
        font-size: 13px;
        line-height: 17px;
        border: none;
    }
    
    .mainTable{
        margin: 30px 0;
    }
    
    .mainproducttable{
        margin: 0;
        padding: 0;
        width: 100%;
    }
    
    .mainproducttable td{
        padding: 5px 7px;
        font-size: 12px;
        border: 1px solid #ccc;
    }
    
    tr.headerTable {
        background-color: #e2e2e2;
    }
    
    tr.headerTable td{
        font-size: 13px;
        padding: 7px;
    }
    
    .boxFrozen {
        border: 1px solid #ccc;
        text-align: center;
        margin-bottom: 6px;
        border-bottom: 0px solid #ccc;
    }
    
    .boxFrozen h3{
        padding: 5px;
        color: #fff;
        margin: 0;
        background-color: #ff1414;
        font-size: 16px;
    }
    
    .boxFrozen p{
        font-size: 16px;
        padding: 5px 0px;
        border-bottom: 1px solid #ccc;
    }
    
    .footerInvoice{
        margin-top: 100px;
    }

    @media only screen and (max-width: 567px) {
        .invoice-inner {
            padding: 10px;
            margin: 10px 0px;
        }
        .invoiceContainer{
            padding:0;
        }
    }
</style>

@endpush @section('contents')

<div class="userdashboard">
    <div class="container">
        <div class="row" style="margin: 0;">
            <div class="col-lg-3 usersidebardiv">
                @include(App\Models\General::first()->theme.'.customer.includes.sidebar')
            </div>
            <div class="col-lg-9 usermainbody">
                @include(App\Models\General::first()->theme.'.alerts')
                <p class="text-center" style="position: absolute;"><span id="PrintAction" class="btn btn-sm btn-success" style="background-color: #b4802c;border-color: #b4802c;"><i class="fa fa-print"></i> Print</span></p>
                <div class="invoicePage PrintAreaContact">
                    
                	<div class="invoiceContainer">
	                    <div class="invoice-inner InnerInvoiePage" >
                			<div class="invoice-header">
                				<div class="row">
                					<div class="col-4">
                						<img src="{{asset(general()->logo())}}" style="max-width: 100%;">
                					</div>
                					<div class="col-1"></div>
                					<div class="col-7" style="text-align: end;">
                						<h6>CONTACT INFORMATION:</h6>
                						<p>{{general()->address_one}}</p>
                						<p>{{general()->mobile}}</p>
                						<p>{{general()->email}}</p>
                						<p>{{general()->website}}</p>
                					</div>
                				</div>
                			</div>
                			<hr style="border: 2px solid #00549e; margin: 0;">
                			<h2 style="margin: 10px 0px;font-size: 41px;letter-spacing: 3px;color: #00549e;">INVOICE</h2>
                			<div class="orderInfo">
                				<div class="row" style="flex-wrap: wrap;">
                					<div class="col-6 mt-1" style="flex: 0 0 50%;max-width: 50%;margin-top: 1rem;">
                						<p style="margin: 0;line-height: 15px;font-size: 12px;">Order From:</p>
                						<p style="margin: 0;line-height: 15px;font-size: 12px;">
                						@if($order->name)
                						{{$order->name}}
                						@else
                						{{$order->user?$order->user->name:''}}
                						@endif
                						</p>
                						<p style="margin: 0;line-height: 15px;font-size: 12px;">
                						    	@if($order->mobile)
                        						{{$order->mobile}}
                        						@else
                        						{{$order->user?$order->user->mobile:''}}
                        						@endif
                						 </p>
                						<p style="margin: 0;line-height: 15px;font-size: 12px;">
                						        @if($order->email)
                        						{{$order->email}}
                        						@else
                        						{{$order->user?$order->user->email:''}}
                        						@endif
                						</p>
                						<p style="margin: 0;line-height: 15px;font-size: 12px;">{{$order->fullAddress()}}</p>
                					</div>
                					<div class="col-6" style="flex: 0 0 50%;max-width: 50%;">
                						<div class="ordrinfotable" style="border: 1px solid #ccc;padding: 10px 12px;">
                							<table class="tableOrderinfo table">
        									  <thead>
        									    <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Invoice Number</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ $order->invoice }}</td>
        									    </tr>
        									    <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Invoice Date</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ $order->created_at->format('d-m-Y h:i A') }}</td>
        									    </tr>
        									    <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Order Status</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ ucfirst($order->order_status)}}</td>
        									    </tr>
        									    <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Order Date</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ $order->created_at->format('d-m-Y h:i A') }}</td>
        									    </tr>
        									     <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Method</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ ucfirst($order->payment_method)}}</td>
        									    </tr>
        									    <tr>
        									      <td style="width: 40%;padding: 0;font-size: 13px;line-height: 17px;border: none;">Payment</td>
        									      <td style="padding: 0;font-size: 13px;line-height: 17px;border: none;">: {{ ucfirst($order->payment_status)}}</td>
        									    </tr>
        									  </thead>
        									</table>
                						</div>							
                					</div>
                				</div>
                			</div>
                            
                            <div class="table-responsive">
                    			<div class="mainTable" style="margin: 30px 0;">
                    				<table class="table mainproducttable">
            						  <thead>
            						    <tr class="headerTable">
            						      <td style="width: 50%;">Product Name & Description</td>
            						      <td style="width: 12%; text-align: center;">Quantity</td>
            						      <td style="width: 12%; text-align: center;">Unit Price</td>
            						      <td style="width: 15%; text-align: center;">Total Price ({{general()->currency}})</td>
            						    </tr>
            						  </thead>
            						  <tbody>
            						      
            						    @foreach($order->items as $i=>$item)
            						    <tr>
            						      <td>{{ $item->product_name }}</td>
            						      <td style="text-align: center;">{{$item->quantity}}</td>
            						      <td style="text-align: center;">{{ priceFormat($item->price) }}</td>
            						      <td style="text-align: center;">{{ priceFormat($item->final_price) }}</td>
            						    </tr>
            						    @endforeach
            						    
            						    <tr>
            						      <td colspan="1" style="text-align: end;">Product Qty</td>
            						      <td style="text-align: center;">{{$order->items->sum('quantity')}}</td>
            						      <td style="text-align: end;">Subtotal</td>
            						      <td style="text-align: center;">{{ priceFormat($order->total_price) }}</td>
            						    </tr>
            						    <tr>
            						      <td colspan="3" style="text-align: end;">Tax</td>
            						      <td style="text-align: center;">{{ priceFormat($order->tax) }}</td>
            						    </tr>
            						    <tr>
            						      <td colspan="3" style="text-align: end;">Shipping</td>
            						      <td style="text-align: center;">
            						      @if($order->shipping_charge>0)
            						      {{priceFormat($order->shipping_charge)}}
            						      @else
            						      Free Shipping
            						      @endif
            						      </td>
            						    </tr>
            						    <tr>
            						      <td colspan="3" style="text-align: end;">Grand Total</td>
            						      <td style="text-align: center;">{{ priceFormat($order->grand_total) }}</td>
            						    </tr>
            						  </tbody>
            						</table>
                    			</div>
                			</div>
        
                			<div class="frozenTable">
                				<div class="row" style="display:flex;">
                					<div class="col-md-12" style="">
                					    @if($order->payment_status=='paid')
                					    <div class="paidsStatus" style="text-align:right;">
                					        <img src="{{asset('public/medies/paid.png')}}" style="max-width:80px;">
                					    </div>
                					     @endif
                					</div>
                					@if($order->note)
                    				<div class="col-12">
                    				    <b>Order Note</b><br>
                    				    <p>{!!$order->note!!}</p>
                    				</div>
                    				@endif
                    				
                				</div>
                			</div>
        
                			<div class="footerInvoice">
                				<div class="row" style="dispaly:flex;">
                					<div class="col-6" style="flex: 0 0 50%;max-width: 50%;">
                						<p>Thank you for shopping from {{general()->title}}</p>
                					</div>
                					<div class="col-6" style="text-align: end;flex: 0 0 50%;max-width: 50%;">
                						------------------------
                						<p>Authorised Sign</p>
                					</div>
                				</div>
                			</div>
                		</div>
                        </div>
                	
                	
                </div>
                
            </div>
        </div>
    </div>
</div>
@endsection @push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.2/jQuery.print.min.js"></script>
<script src="{{asset('public/batikrom/js/inword.js')}}"></script>

<script type='text/javascript'>
    
    $(document).ready(function(){
        
        var date = new Date();
        date.setDate(date.getDate() + 7);
        
        console.log(date);
        
        
        var words="";

        $(function() {
        	var totalamount = (
        		Number($('#inWordTotal').data('amount'))
        		);
        	words = toWords(totalamount);
        	$('#inWordTotal').empty().append(words + 'Taka only');
        });
        
    });
</script>


<script src="{{asset('public/app-assets/js/printThis.js')}}"></script>

<script type="text/javascript">
	$('#PrintAction').on("click", function () {
        $('.PrintAreaContact').printThis();
      });
</script>
@endpush
